/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2008 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and may be covered by U.S. and Foreign Patents,
* patents in process, and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
*
* AdobePatentID="B564"
* AdobePatentID="B565"
*
**************************************************************************/


//--------------------------------------------------------------------
// CLASS:
//   ICEStylesheetItem
//
// DESCRIPTION:
//  This class is used to encapsulate all properties of a stylesheet item.
//
// ARGUMENTS:
//   label - (string) the string that will be displayed next to the checkbox (currently does nothing)
//   value - (string) checkbox value attribute
//   disabled - (boolean) set to true if the linked stylesheet is inside a locked region
//   checked - (boolean) set to true if the linked stylesheet already has the ice:classes attribute added
//   node - (object) the link node
//
// RETURNS:
//   nothing
//--------------------------------------------------------------------
ICEStylesheetItem = function(label, value, disabled, checked, node)
{
  this.label = label;
  this.value = value;
  this.disabled = disabled;
  this.checked = checked;
  this.node = node;
};

/***************** Getters and setters ******************/

ICEStylesheetItem.prototype.getLabel = function()
{
  return this.label;
};

ICEStylesheetItem.prototype.setLabel = function(labelParam)
{
  this.label = labelParam;
};

ICEStylesheetItem.prototype.getValue = function()
{
  return this.value;
};

ICEStylesheetItem.prototype.setValue = function(valueParam)
{
  this.value = valueParam;
};

ICEStylesheetItem.prototype.getDisabled = function()
{
  return this.disabled;
};

ICEStylesheetItem.prototype.setDisabled = function(disabledParam)
{
  this.disabled = disabledParam;
};

ICEStylesheetItem.prototype.getChecked = function()
{
  return this.checked;
};

ICEStylesheetItem.prototype.setChecked = function(checkedParam)
{
  this.checked = checkedParam;
};

ICEStylesheetItem.prototype.getNode = function()
{
  return this.node;
};

ICEStylesheetItem.prototype.setNode = function(nodeParam)
{
  this.node = nodeParam;
};
